/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.osiris3.platform;

import com.rameses.osiris3.platform.CipherUtil;
import com.rameses.osiris3.platform.ModuleEntry;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class UpdateConf
extends DefaultHandler {
    private List<ModuleEntry> modules = new ArrayList<ModuleEntry>();
    private Map env = new HashMap();
    private StringBuffer sbuff = new StringBuffer();
    private String confPath;
    private long lastModified;
    private String appPath;
    private String appurl;
    private String modulePath;

    public UpdateConf(String appurl, String appPath, String confPath) {
        this.appurl = appurl;
        this.appPath = appPath;
        this.confPath = confPath;
        this.modulePath = confPath.substring(0, confPath.lastIndexOf("/") + 1);
    }

    public void load() throws Exception {
        this.modules.clear();
        this.env.clear();
        File f = new File(this.confPath);
        if (!f.exists()) {
            throw new Exception(this.confPath + " does not exist!");
        }
        this.lastModified = f.lastModified();
        FileInputStream fis = null;
        ObjectInputStream ois = null;
        ByteArrayInputStream bis = null;
        try {
            fis = new FileInputStream(f);
            ois = new ObjectInputStream(fis);
            Object o = CipherUtil.decode((Serializable)ois.readObject());
            bis = new ByteArrayInputStream(o.toString().getBytes());
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            parser.parse((InputStream)bis, (DefaultHandler)this);
        }
        catch (Exception ex) {
            f.delete();
            throw ex;
        }
        finally {
            try {
                fis.close();
            }
            catch (Exception exception) {}
            try {
                bis.close();
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void startElement(String string, String string0, String qName, Attributes attr) throws SAXException {
        if (qName.equals("module")) {
            String name = attr.getValue("file");
            if (name == null) {
                throw new IllegalStateException("module file must not be null");
            }
            String sz = attr.getValue("size");
            String version = attr.getValue("version");
            ModuleEntry me = new ModuleEntry(name, version, sz);
            me.setModulePath(this.modulePath);
            if (this.getModules().indexOf(me) < 0) {
                this.getModules().add(me);
            }
        } else if (qName.equals("env")) {
            this.sbuff.delete(0, this.sbuff.length());
        }
    }

    private void populate(Map map, Attributes attr) {
        for (int i = 0; i < attr.getLength(); ++i) {
            map.put(attr.getQName(i), attr.getValue(i));
        }
    }

    @Override
    public void characters(char[] c, int i, int i0) throws SAXException {
        this.sbuff.append(c, i, i0);
    }

    @Override
    public void endElement(String string, String string0, String qName) throws SAXException {
        if (qName.equals("env")) {
            try {
                Properties props = new Properties();
                props.load(new ByteArrayInputStream(this.sbuff.toString().getBytes()));
                Iterator<Map.Entry<Object, Object>> iterator = props.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<Object, Object> o;
                    Map.Entry<Object, Object> me = o = iterator.next();
                    String key = (me.getKey() + "").trim();
                    String val = (me.getValue() + "").trim();
                    if (val.endsWith(";")) {
                        val = val.substring(0, val.length() - 1);
                    }
                    this.env.put(key, val);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public List<ModuleEntry> getModules() {
        return this.modules;
    }

    public Map getEnv() {
        return this.env;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public void setAppPath(String appPath) {
        this.appPath = appPath;
    }

    public String getModulePath() {
        return this.modulePath;
    }
}

