/*
 * Decompiled with CFR 0.152.
 */
package com.topaz.sigplus.util;

import com.topaz.sigplus.util.SigCrypt;
import com.topaz.sigplus.util.SigDataPoint;
import com.topaz.sigplus.util.SigDataType;
import com.topaz.sigplus.util.SigDrawParameters;
import com.topaz.sigplus.util.SigInfo;
import com.topaz.sigplus.util.SigOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class SigWriter {
    static final int CR = 13;
    static final int LF = 10;
    static final int SP = 32;
    private int compressionMode;
    private SigCrypt cryptor;
    static final int TopazDataTag = 65535;
    static final int TopazPressureTag = 0;
    static final int TopazTimeTag = 1;

    public byte[] writeSigToByteArray(SigDataType sig, SigDrawParameters displayParams, SigDrawParameters imageParams) {
        byte[] sigArray = this.compressionMode == 0 ? this.writeSigUncompressed(sig, displayParams, imageParams) : this.writeSigCompressed(sig, displayParams, imageParams);
        return this.cryptor.encryptBuffer(sigArray);
    }

    public boolean writeSigToFile(String fileName, SigDataType sig, SigDrawParameters displayParams, SigDrawParameters imageParams) {
        byte[] buffer = this.writeSigToByteArray(sig, displayParams, imageParams);
        try {
            FileOutputStream file = new FileOutputStream(fileName);
            file.write(buffer);
            file.close();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    private void writeSpace(SigOutputStream str) {
        str.writeBinaryByte(32);
    }

    private void writeCrLf(SigOutputStream str) {
        str.writeBinaryByte(13);
        str.writeBinaryByte(10);
    }

    public SigWriter(int compMode, SigCrypt crypt) {
        this.compressionMode = compMode;
        this.cryptor = crypt;
    }

    public void saveSigInfo(SigOutputStream stream, SigDataType sig, SigDrawParameters displayParams, SigDrawParameters imageParams) {
        if (!sig.getSaveSigInfo()) {
            return;
        }
        String str = sig.getTimeStamp();
        int strLen = str.length();
        stream.writeBinaryByte(strLen);
        int i = 0;
        while (i < strLen) {
            stream.writeBinaryByte(str.charAt(i));
            ++i;
        }
        stream.writeBinaryShort(displayParams.getTimeStampX());
        stream.writeBinaryShort(displayParams.getTimeStampY());
        stream.writeBinaryShort(displayParams.getTimeStampSize());
        if (displayParams.getTimeStamp()) {
            stream.writeBinaryShort(1);
        } else {
            stream.writeBinaryShort(0);
        }
        stream.writeBinaryShort(imageParams.getTimeStampX());
        stream.writeBinaryShort(imageParams.getTimeStampY());
        stream.writeBinaryShort(imageParams.getTimeStampSize());
        if (imageParams.getTimeStamp()) {
            stream.writeBinaryShort(1);
        } else {
            stream.writeBinaryShort(0);
        }
        str = sig.getAnnotation();
        strLen = str.length();
        stream.writeBinaryByte(strLen);
        i = 0;
        while (i < strLen) {
            stream.writeBinaryByte(str.charAt(i));
            ++i;
        }
        stream.writeBinaryShort(displayParams.getAnnotationX());
        stream.writeBinaryShort(displayParams.getAnnotationY());
        stream.writeBinaryShort(displayParams.getAnnotationSize());
        if (displayParams.getAnnotation()) {
            stream.writeBinaryShort(1);
        } else {
            stream.writeBinaryShort(0);
        }
        stream.writeBinaryShort(imageParams.getAnnotationX());
        stream.writeBinaryShort(imageParams.getAnnotationY());
        stream.writeBinaryShort(imageParams.getAnnotationSize());
        if (imageParams.getAnnotation()) {
            stream.writeBinaryShort(1);
        } else {
            stream.writeBinaryShort(0);
        }
    }

    public byte[] writeSigCompressed(SigDataType sig, SigDrawParameters displayParams, SigDrawParameters imageParams) {
        SigInfo info = new SigInfo();
        SigOutputStream sigStream = new SigOutputStream();
        int firstPointInStroke = 0;
        int deltaSamps = this.compressionMode;
        int pntIdx = 0;
        int pnts = sig.getSigData(info);
        pnts = info.getNumPoints();
        long[] pressureData = new long[pnts + 1];
        long[] timeData = new long[pnts + 1];
        sigStream.writeBinaryShort(info.numStrokes);
        int i = 0;
        while (i < info.numStrokes) {
            int dy;
            int dx;
            SigDataPoint pnt;
            int v = info.getNumPointsInStroke(i);
            int nPoints = (v - 2) / deltaSamps + 2;
            sigStream.writeBinaryShort(nPoints);
            SigDataPoint prevPnt = (SigDataPoint)info.pointData.get(firstPointInStroke);
            sigStream.writeBinaryShort(prevPnt.x);
            sigStream.writeBinaryShort(prevPnt.y);
            pressureData[pntIdx] = prevPnt.p;
            timeData[pntIdx] = prevPnt.t;
            ++pntIdx;
            int j = firstPointInStroke + 1;
            while (j < firstPointInStroke + v - 1) {
                if ((j - firstPointInStroke) % deltaSamps == 0) {
                    pnt = (SigDataPoint)info.pointData.get(j);
                    dx = pnt.x - prevPnt.x;
                    dy = pnt.y - prevPnt.y;
                    sigStream.writeBinaryByte(dx);
                    sigStream.writeBinaryByte(dy);
                    pressureData[pntIdx] = prevPnt.p;
                    timeData[pntIdx] = prevPnt.t;
                    ++pntIdx;
                    prevPnt = pnt;
                }
                ++j;
            }
            if (v > 1) {
                pnt = (SigDataPoint)info.pointData.get(j);
                dx = pnt.x - prevPnt.x;
                dy = pnt.y - prevPnt.y;
                sigStream.writeBinaryByte(dx);
                sigStream.writeBinaryByte(dy);
                pressureData[pntIdx] = prevPnt.p;
                timeData[pntIdx] = prevPnt.t;
                ++pntIdx;
            }
            firstPointInStroke += v;
            ++i;
        }
        this.saveSigInfo(sigStream, sig, displayParams, imageParams);
        this.savePressureDataToFile(sigStream, sig, pressureData, pntIdx);
        this.saveTimeDataToFile(sigStream, sig, pressureData, pntIdx);
        return sigStream.toByteArray();
    }

    public byte[] writeSigUncompressed(SigDataType sig, SigDrawParameters displayParams, SigDrawParameters imageParams) {
        SigInfo info = new SigInfo();
        SigOutputStream sigStream = new SigOutputStream();
        int pntIdx = 0;
        int pnts = sig.getSigData(info);
        pnts = info.getNumPoints();
        long[] pressureData = new long[pnts];
        long[] timeData = new long[pnts];
        sigStream.writeAsciiInt(info.numPoints);
        this.writeCrLf(sigStream);
        sigStream.writeAsciiInt(info.numStrokes);
        this.writeCrLf(sigStream);
        int i = 0;
        while (i < pnts) {
            SigDataPoint pnt = (SigDataPoint)info.pointData.get(i);
            sigStream.writeAsciiInt(pnt.x);
            this.writeSpace(sigStream);
            sigStream.writeAsciiInt(pnt.y);
            this.writeCrLf(sigStream);
            pressureData[pntIdx] = pnt.p;
            timeData[pntIdx] = pnt.t;
            ++pntIdx;
            ++i;
        }
        i = 0;
        while (i < info.numStrokes) {
            int v = (Integer)info.strokeData.get(i);
            sigStream.writeAsciiInt(v);
            this.writeCrLf(sigStream);
            ++i;
        }
        this.saveSigInfo(sigStream, sig, displayParams, imageParams);
        this.savePressureDataToFile(sigStream, sig, pressureData, pntIdx);
        this.saveTimeDataToFile(sigStream, sig, pressureData, pntIdx);
        return sigStream.toByteArray();
    }

    public void savePressureDataToFile(SigOutputStream destFile, SigDataType sig, long[] pressureData, int numPoints) {
        if (!sig.savePressureData) {
            return;
        }
        int temp = -1;
        destFile.writeBinaryShort(temp);
        temp = 0;
        destFile.writeBinaryShort(temp);
        int i = 0;
        while (i < numPoints) {
            long v = pressureData[i];
            destFile.writeBinaryInt((int)v);
            ++i;
        }
    }

    public void saveTimeDataToFile(SigOutputStream destFile, SigDataType sig, long[] timeData, int numPoints) {
        if (!sig.saveTimeData) {
            return;
        }
        int temp = -1;
        destFile.writeBinaryShort(temp);
        temp = 0;
        destFile.writeBinaryShort(temp);
        int i = 0;
        while (i < numPoints) {
            long v = timeData[i];
            destFile.writeBinaryInt((int)v);
            ++i;
        }
    }
}

