/*
 * Decompiled with CFR 0.152.
 */
package jcmdline;

import jcmdline.AbstractParameter;
import jcmdline.CmdLineException;
import jcmdline.Strings;

public class StringParam
extends AbstractParameter {
    public static final String DEFAULT_OPTION_LABEL = Strings.get("StringParam.defaultOptionLabel");
    protected static final int UNSPECIFIED_LENGTH = -1;
    protected int maxValLen = -1;
    protected int minValLen = -1;

    public StringParam(String tag, String desc) {
        this(tag, desc, 0, -1, true, false, false);
    }

    public StringParam(String tag, String desc, boolean optional) {
        this(tag, desc, 0, -1, optional, false, false);
    }

    public StringParam(String tag, String desc, int minValLen, int maxValLen) {
        this(tag, desc, minValLen, maxValLen, true, false, false);
    }

    public StringParam(String tag, String desc, int minValLen, int maxValLen, boolean optional) {
        this(tag, desc, minValLen, maxValLen, optional, false, false);
    }

    public StringParam(String tag, String desc, int minValLen, int maxValLen, boolean optional, boolean multiValued) {
        this(tag, desc, minValLen, maxValLen, optional, multiValued, false);
    }

    public StringParam(String tag, String desc, int minValLen, int maxValLen, boolean optional, boolean multiValued, boolean hidden) {
        this.setTag(tag);
        this.setMinValLen(minValLen);
        if (maxValLen >= 0) {
            this.setMaxLength(maxValLen);
        }
        this.setDesc(desc);
        this.optional = optional;
        this.multiValued = multiValued;
        this.hidden = hidden;
        this.setOptionLabel(DEFAULT_OPTION_LABEL);
    }

    public StringParam(String tag, String desc, String[] acceptableValues) {
        this(tag, desc, acceptableValues, true, false, false);
    }

    public StringParam(String tag, String desc, String[] acceptableValues, boolean optional) {
        this(tag, desc, acceptableValues, optional, false, false);
    }

    public StringParam(String tag, String desc, String[] acceptableValues, boolean optional, boolean multiValued) {
        this(tag, desc, acceptableValues, optional, multiValued, false);
    }

    public StringParam(String tag, String desc, String[] acceptableValues, boolean optional, boolean multiValued, boolean hidden) {
        this.setTag(tag);
        this.setDesc(desc);
        this.setAcceptableValues(acceptableValues);
        this.optional = optional;
        this.multiValued = multiValued;
        this.hidden = hidden;
        this.setOptionLabel(DEFAULT_OPTION_LABEL);
    }

    public void validateValue(String val) throws CmdLineException {
        super.validateValue(val);
        if (this.minValLen != -1 && val.length() < this.minValLen) {
            throw new CmdLineException(Strings.get("StringParam.valTooShort", new Object[]{this.tag, new Integer(this.minValLen)}));
        }
        if (this.maxValLen != -1 && val.length() > this.maxValLen) {
            throw new CmdLineException(Strings.get("StringParam.valTooLong", new Object[]{this.tag, new Integer(this.maxValLen)}));
        }
    }

    public int getMinValLen() {
        return this.minValLen;
    }

    public void setMinValLen(int minValLen) {
        if (minValLen < 0) {
            throw new IllegalArgumentException(Strings.get("StringParam.minTooSmall", new Object[]{this.tag}));
        }
        if (this.maxValLen != -1 && minValLen > this.maxValLen) {
            throw new IllegalArgumentException(Strings.get("StringParam.maxLessThanMin", new Object[]{this.tag}));
        }
        this.minValLen = minValLen;
    }

    public int getMaxValLen() {
        return this.maxValLen;
    }

    public void setMaxLength(int maxValLen) {
        if (maxValLen < 0) {
            throw new IllegalArgumentException(Strings.get("StringParam.maxTooSmall", new Object[]{this.tag}));
        }
        if (this.minValLen != -1 && maxValLen < this.minValLen) {
            throw new IllegalArgumentException(Strings.get("StringParam.maxLessThanMin", new Object[]{this.tag}));
        }
        this.maxValLen = maxValLen;
    }
}

