/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql;

import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.hibernate.dialect.Dialect;

public final class Template {
    private static final Set KEYWORDS = new HashSet();
    private static final Set BEFORE_TABLE_KEYWORDS = new HashSet();
    private static final Set FUNCTION_KEYWORDS = new HashSet();
    public static final String TEMPLATE = "$PlaceHolder$";

    private Template() {
    }

    public static String renderWhereStringTemplate(String sqlWhereString, Dialect dialect) {
        return Template.renderWhereStringTemplate(sqlWhereString, TEMPLATE, dialect);
    }

    public static String renderWhereStringTemplate(String sqlWhereString, String placeholder, Dialect dialect) {
        String nextToken;
        String symbols = "=><!+-*/()',|&" + " \n\r\f\t" + dialect.openQuote() + dialect.closeQuote();
        StringTokenizer tokens = new StringTokenizer(sqlWhereString, symbols, true);
        StringBuffer result = new StringBuffer();
        boolean quoted = false;
        boolean quotedIdentifier = false;
        boolean beforeTable = false;
        boolean inFromClause = false;
        boolean afterFromTable = false;
        boolean hasMore = tokens.hasMoreTokens();
        String string = nextToken = hasMore ? tokens.nextToken() : null;
        while (hasMore) {
            String token = nextToken;
            String lcToken = token.toLowerCase();
            hasMore = tokens.hasMoreTokens();
            String string2 = nextToken = hasMore ? tokens.nextToken() : null;
            if (!quotedIdentifier && "'".equals(token)) {
                boolean bl = quoted = !quoted;
            }
            if (!quoted && !quotedIdentifier && dialect.openQuote() == token.charAt(0)) {
                quotedIdentifier = true;
            }
            if (!quoted && quotedIdentifier && dialect.closeQuote() == token.charAt(0)) {
                quotedIdentifier = false;
            }
            if (quoted || quotedIdentifier || Character.isWhitespace(token.charAt(0))) {
                result.append(token);
            } else if (beforeTable) {
                result.append(token);
                beforeTable = false;
                afterFromTable = true;
            } else if (afterFromTable) {
                if (!"as".equals(lcToken)) {
                    afterFromTable = false;
                }
                result.append(token);
            } else if (Template.isNamedParameter(token)) {
                result.append(token);
            } else if (Template.isIdentifier(token, dialect) && !Template.isFunction(lcToken, nextToken, dialect)) {
                result.append(placeholder).append('.').append(dialect.quote(token));
            } else {
                if (BEFORE_TABLE_KEYWORDS.contains(lcToken)) {
                    beforeTable = true;
                    inFromClause = true;
                } else if (inFromClause && ",".equals(lcToken)) {
                    beforeTable = true;
                }
                result.append(token);
            }
            if (!inFromClause || !KEYWORDS.contains(lcToken) || BEFORE_TABLE_KEYWORDS.contains(lcToken)) continue;
            inFromClause = false;
        }
        return result.toString();
    }

    private static boolean isNamedParameter(String token) {
        return token.startsWith(":");
    }

    private static boolean isFunction(String lcToken, String nextToken, Dialect dialect) {
        return "(".equals(nextToken) || KEYWORDS.contains(lcToken) || dialect.getFunctions().containsKey(lcToken) || FUNCTION_KEYWORDS.contains(lcToken);
    }

    private static boolean isIdentifier(String token, Dialect dialect) {
        return token.charAt(0) == '`' || Character.isLetter(token.charAt(0)) && token.indexOf(46) < 0;
    }

    public static String renderOrderByStringTemplate(String sqlOrderByString, Dialect dialect) {
        StringTokenizer tokens = new StringTokenizer(sqlOrderByString, ",");
        StringBuffer result = new StringBuffer();
        while (tokens.hasMoreTokens()) {
            String column = dialect.quote(tokens.nextToken().trim());
            result.append(TEMPLATE).append('.').append(column);
            if (!tokens.hasMoreTokens()) continue;
            result.append(", ");
        }
        return result.toString();
    }

    static {
        KEYWORDS.add("and");
        KEYWORDS.add("or");
        KEYWORDS.add("not");
        KEYWORDS.add("like");
        KEYWORDS.add("is");
        KEYWORDS.add("in");
        KEYWORDS.add("between");
        KEYWORDS.add("null");
        KEYWORDS.add("select");
        KEYWORDS.add("distinct");
        KEYWORDS.add("from");
        KEYWORDS.add("join");
        KEYWORDS.add("inner");
        KEYWORDS.add("outer");
        KEYWORDS.add("left");
        KEYWORDS.add("right");
        KEYWORDS.add("on");
        KEYWORDS.add("where");
        KEYWORDS.add("having");
        KEYWORDS.add("group");
        KEYWORDS.add("order");
        KEYWORDS.add("by");
        KEYWORDS.add("desc");
        KEYWORDS.add("asc");
        KEYWORDS.add("limit");
        KEYWORDS.add("any");
        KEYWORDS.add("some");
        KEYWORDS.add("exists");
        KEYWORDS.add("all");
        BEFORE_TABLE_KEYWORDS.add("from");
        BEFORE_TABLE_KEYWORDS.add("join");
        FUNCTION_KEYWORDS.add("as");
        FUNCTION_KEYWORDS.add("leading");
        FUNCTION_KEYWORDS.add("trailing");
        FUNCTION_KEYWORDS.add("from");
        FUNCTION_KEYWORDS.add("case");
        FUNCTION_KEYWORDS.add("when");
        FUNCTION_KEYWORDS.add("then");
        FUNCTION_KEYWORDS.add("else");
        FUNCTION_KEYWORDS.add("end");
    }
}

