/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.annotations;

import java.awt.geom.AffineTransform;
import java.util.HashMap;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.PObject;
import org.icepdf.core.pobjects.StateManager;
import org.icepdf.core.pobjects.acroform.ButtonFieldDictionary;
import org.icepdf.core.pobjects.acroform.FieldDictionary;
import org.icepdf.core.pobjects.annotations.AbstractWidgetAnnotation;
import org.icepdf.core.pobjects.annotations.Annotation;
import org.icepdf.core.pobjects.annotations.Appearance;
import org.icepdf.core.util.Library;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ButtonWidgetAnnotation
extends AbstractWidgetAnnotation<ButtonFieldDictionary> {
    private ButtonFieldDictionary fieldDictionary;
    protected Name originalAppearance;

    public ButtonWidgetAnnotation(Library l, HashMap h) {
        super(l, h);
        this.fieldDictionary = new ButtonFieldDictionary(this.library, this.entries);
    }

    public ButtonWidgetAnnotation(Annotation widgetAnnotation) {
        super(widgetAnnotation.getLibrary(), widgetAnnotation.getEntries());
        this.fieldDictionary = new ButtonFieldDictionary(this.library, this.entries);
        this.setPObjectReference(widgetAnnotation.getPObjectReference());
    }

    @Override
    public void resetAppearanceStream(double dx, double dy, AffineTransform pageSpace) {
        Appearance appearance = (Appearance)this.appearances.get(this.currentAppearance);
        if (appearance != null) {
            appearance.updateAppearanceDictionary(this.entries);
        }
        StateManager stateManager = this.library.getStateManager();
        stateManager.addChange(new PObject(this, this.getPObjectReference()));
        Name selectedName = appearance.getSelectedName();
        if (this.getFieldDictionary().hasFieldValue()) {
            this.entries.put(FieldDictionary.V_KEY, selectedName);
        } else if (this.getFieldDictionary().getParent() != null && this.getFieldDictionary().getParent().hasFieldValue()) {
            stateManager.addChange(new PObject(this.getFieldDictionary().getParent(), this.getFieldDictionary().getParent().getPObjectReference()));
        }
        if (this.originalAppearance == null) {
            this.originalAppearance = this.currentAppearance;
        }
    }

    @Override
    public void reset() {
        Object oldValue = this.fieldDictionary.getFieldValue();
        Object defaultFieldValue = this.fieldDictionary.getDefaultFieldValue();
        FieldDictionary parentFaultFieldValue = this.fieldDictionary.getParent();
        if (defaultFieldValue != null) {
            this.changeSupport.firePropertyChange("valueFieldReset", oldValue, defaultFieldValue);
        } else if (parentFaultFieldValue != null) {
            this.changeSupport.firePropertyChange("valueFieldReset", oldValue, parentFaultFieldValue.getDefaultFieldValue());
        } else {
            this.changeSupport.firePropertyChange("valueFieldReset", oldValue, "");
        }
    }

    public void turnOff() {
        Appearance appearance = (Appearance)this.appearances.get(this.currentAppearance);
        if (appearance != null && appearance.hasAlternativeAppearance()) {
            appearance.setSelectedName(appearance.getOffName());
        }
    }

    public boolean isOn() {
        Appearance appearance = (Appearance)this.appearances.get(this.currentAppearance);
        Name selectedNormalAppearance = appearance.getSelectedName();
        return !selectedNormalAppearance.equals(appearance.getOffName());
    }

    public Name toggle() {
        Appearance appearance = (Appearance)this.appearances.get(this.currentAppearance);
        Name selectedNormalAppearance = appearance.getSelectedName();
        if (appearance.hasAlternativeAppearance()) {
            if (!selectedNormalAppearance.equals(appearance.getOffName())) {
                appearance.setSelectedName(appearance.getOffName());
            } else {
                appearance.setSelectedName(appearance.getOnName());
            }
        }
        return appearance.getSelectedName();
    }

    public void turnOn() {
        Appearance appearance = (Appearance)this.appearances.get(this.currentAppearance);
        if (appearance.hasAlternativeAppearance()) {
            appearance.setSelectedName(appearance.getOnName());
        }
    }

    @Override
    public ButtonFieldDictionary getFieldDictionary() {
        return this.fieldDictionary;
    }
}

