/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui.expbuilder;

import it.businesslogic.ireport.gui.expbuilder.ExpObject;
import it.businesslogic.ireport.gui.expbuilder.ExpObjectCellRenderer;
import it.businesslogic.ireport.gui.sheet.Tag;
import it.businesslogic.ireport.util.I18n;
import it.businesslogic.ireport.util.Misc;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ArithmeticOperationHelper
extends JPanel {
    JDialog dialog = null;
    private String expression = null;
    private String language = "java";
    private int dialogResult = 2;
    private JButton jButtonCancel;
    private JButton jButtonOk;
    private JComboBox jComboBoxOperation;
    private JComboBox jComboBoxReturnType;
    private JComboBox jComboBoxType1;
    private JComboBox jComboBoxType2;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabelAdv1;
    private JLabel jLabelAdv2;
    private JLabel jLabelReturnType;
    private JList jList1;
    private JList jList2;
    private JPanel jPanel1;
    private JPanel jPanelReturnType;
    private JPanel jPanelValue1;
    private JPanel jPanelValue2;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JToggleButton jToggleButton1;

    public ArithmeticOperationHelper() {
        this.initComponents();
        this.applyI18n();
        this.jList1.setModel(new DefaultListModel());
        this.jList2.setModel(new DefaultListModel());
        this.jList1.setCellRenderer(new ExpObjectCellRenderer(this.jList1));
        this.jList2.setCellRenderer(new ExpObjectCellRenderer(this.jList2));
        this.jComboBoxType1.addItem(new Tag("auto", I18n.getString("autoType", "Automatic")));
        this.jComboBoxType1.addItem(new Tag("int", I18n.getString("intType", "Integer number (i.e. 123)")));
        this.jComboBoxType1.addItem(new Tag("double", I18n.getString("realType", "Real number (i.e. 123.456)")));
        this.jComboBoxType2.addItem(new Tag("auto", I18n.getString("autoType", "Automatic")));
        this.jComboBoxType2.addItem(new Tag("int", I18n.getString("intType", "Integer number (i.e. 123)")));
        this.jComboBoxType2.addItem(new Tag("double", I18n.getString("realType", "Real number (i.e. 123.456)")));
        this.jComboBoxReturnType.addItem(I18n.getString("autoType", "Automatic"));
        this.jComboBoxReturnType.addItem("BigDecimal");
        this.jComboBoxReturnType.addItem("BigInteger");
        this.jComboBoxReturnType.addItem("Byte");
        this.jComboBoxReturnType.addItem("Double");
        this.jComboBoxReturnType.addItem("Float");
        this.jComboBoxReturnType.addItem("Integer");
        this.jComboBoxReturnType.addItem("Long");
        this.jComboBoxReturnType.addItem("Short");
        this.updateAdvancedOptionsStatus(false);
    }

    public String getFinalReturnType() {
        this.jComboBoxReturnType.removeAllItems();
        if (this.jComboBoxType1.getSelectedIndex() == 0 && this.jComboBoxType1.getSelectedIndex() == 0) {
            return "Integer";
        }
        return "Double";
    }

    public void setValues(List values) {
        if (values == null) {
            return;
        }
        int valids = 0;
        for (int i = 0; i < values.size(); ++i) {
            ExpObject obj = (ExpObject)values.get(i);
            String type = obj.getClassType();
            if (type == null || !type.equals("java.lang.Number") && !type.equals("java.lang.BigDecimal") && !type.equals("java.lang.BigInteger") && !type.equals("java.lang.Byte") && !type.equals("java.lang.Double") && !type.equals("java.lang.Float") && !type.equals("java.lang.Integer") && !type.equals("java.lang.Long") && !type.equals("java.lang.Short")) continue;
            ((DefaultListModel)this.jList1.getModel()).addElement(obj);
            ((DefaultListModel)this.jList2.getModel()).addElement(obj);
            ++valids;
        }
        if (valids > 0) {
            this.jList1.setSelectedIndex(0);
            this.jList2.setSelectedIndex(0);
        }
    }

    public void setOperation(String op) {
        this.jComboBoxOperation.setSelectedItem(op);
    }

    public int showDialog(Component c) {
        Window topLevel = null;
        if (c != null) {
            topLevel = SwingUtilities.getWindowAncestor(c);
        }
        if (topLevel == null) {
            this.dialog = new JDialog();
            this.dialog.setModal(true);
        } else if (topLevel instanceof Frame) {
            this.dialog = new JDialog((Frame)topLevel, true);
        } else if (topLevel instanceof Dialog) {
            this.dialog = new JDialog((Dialog)topLevel, true);
        }
        this.dialog.getContentPane().add(this);
        this.dialog.setDefaultCloseOperation(2);
        this.dialog.setTitle("Arithmetic operation");
        this.dialog.pack();
        Misc.centerFrame(this.dialog);
        this.dialog.setVisible(true);
        return this.getDialogResult();
    }

    private void initComponents() {
        this.jPanelValue1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jList1 = new JList();
        this.jLabelAdv1 = new JLabel();
        this.jComboBoxType1 = new JComboBox();
        this.jComboBoxOperation = new JComboBox();
        this.jPanelValue2 = new JPanel();
        this.jLabel2 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.jList2 = new JList();
        this.jLabelAdv2 = new JLabel();
        this.jComboBoxType2 = new JComboBox();
        this.jPanelReturnType = new JPanel();
        this.jSeparator2 = new JSeparator();
        this.jLabelReturnType = new JLabel();
        this.jComboBoxReturnType = new JComboBox();
        this.jSeparator1 = new JSeparator();
        this.jPanel1 = new JPanel();
        this.jToggleButton1 = new JToggleButton();
        this.jButtonOk = new JButton();
        this.jButtonCancel = new JButton();
        this.setLayout(new GridBagLayout());
        this.setMinimumSize(new Dimension(500, 300));
        this.setPreferredSize(new Dimension(673, 300));
        this.jPanelValue1.setLayout(new GridBagLayout());
        this.jLabel1.setText("Value 1");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        this.jPanelValue1.add((Component)this.jLabel1, gridBagConstraints);
        this.jList1.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                ArithmeticOperationHelper.this.jList1ValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jList1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.jPanelValue1.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jLabelAdv1.setText("Consider this number as:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.jPanelValue1.add((Component)this.jLabelAdv1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.jPanelValue1.add((Component)this.jComboBoxType1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanelValue1, gridBagConstraints);
        this.jComboBoxOperation.setModel(new DefaultComboBoxModel<String>(new String[]{"+", "-", "/", "*"}));
        this.jComboBoxOperation.setMinimumSize(new Dimension(50, 18));
        this.jComboBoxOperation.setPreferredSize(new Dimension(50, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        this.add((Component)this.jComboBoxOperation, gridBagConstraints);
        this.jPanelValue2.setLayout(new GridBagLayout());
        this.jLabel2.setText("Value 2");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        this.jPanelValue2.add((Component)this.jLabel2, gridBagConstraints);
        this.jList2.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                ArithmeticOperationHelper.this.jList2ValueChanged(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.jList2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.jPanelValue2.add((Component)this.jScrollPane2, gridBagConstraints);
        this.jLabelAdv2.setText("Consider this number as:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.jPanelValue2.add((Component)this.jLabelAdv2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.jPanelValue2.add((Component)this.jComboBoxType2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanelValue2, gridBagConstraints);
        this.jPanelReturnType.setLayout(new GridBagLayout());
        this.jSeparator2.setMinimumSize(new Dimension(2, 2));
        this.jSeparator2.setPreferredSize(new Dimension(2, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        this.jPanelReturnType.add((Component)this.jSeparator2, gridBagConstraints);
        this.jLabelReturnType.setText("Return type:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanelReturnType.add((Component)this.jLabelReturnType, gridBagConstraints);
        this.jComboBoxReturnType.setMinimumSize(new Dimension(200, 18));
        this.jComboBoxReturnType.setPreferredSize(new Dimension(200, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 4, 4);
        this.jPanelReturnType.add((Component)this.jComboBoxReturnType, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jPanelReturnType, gridBagConstraints);
        this.jSeparator1.setMinimumSize(new Dimension(2, 2));
        this.jSeparator1.setPreferredSize(new Dimension(2, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        this.add((Component)this.jSeparator1, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.jToggleButton1.setText("Advanced options");
        this.jToggleButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ArithmeticOperationHelper.this.jToggleButton1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.jPanel1.add((Component)this.jToggleButton1, gridBagConstraints);
        this.jButtonOk.setText("Ok");
        this.jButtonOk.setActionCommand("OK");
        this.jButtonOk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ArithmeticOperationHelper.this.jButtonOkActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.jButtonOk, gridBagConstraints);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ArithmeticOperationHelper.this.jButtonCancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.jPanel1.add((Component)this.jButtonCancel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.jPanel1, gridBagConstraints);
    }

    private void jList2ValueChanged(ListSelectionEvent evt) {
    }

    private void jButtonOkActionPerformed(ActionEvent evt) {
        String exp = "";
        if (this.jList1.getSelectedIndex() < 0) {
            JOptionPane.showMessageDialog(this, I18n.getString("ArithmeticOperationHelper.msg1", "Please select an object in the first list"));
            return;
        }
        if (this.jList2.getSelectedIndex() < 0) {
            JOptionPane.showMessageDialog(this, I18n.getString("ArithmeticOperationHelper.msg2", "Please select an object from the second list"));
            return;
        }
        ExpObject expObj1 = (ExpObject)this.jList1.getSelectedValue();
        ExpObject expObj2 = (ExpObject)this.jList2.getSelectedValue();
        if (this.getLanguage().equals("groovy")) {
            this.setExpression(expObj1.getExpression() + " " + this.jComboBoxOperation.getSelectedItem() + " " + expObj2.getExpression());
        } else {
            String type;
            exp = expObj1.getExpression();
            if (this.jComboBoxType1.getSelectedIndex() == 0) {
                type = expObj1.getClassType();
                if (type.equals("java.lang.Number")) {
                    exp = exp + ".doubleValue()";
                }
                if (type.equals("java.lang.BigDecimal")) {
                    exp = exp + ".doubleValue()";
                }
                if (type.equals("java.lang.BigInteger")) {
                    exp = exp + ".longValue()";
                }
                if (type.equals("java.lang.Byte")) {
                    exp = exp + ".byteValue()";
                }
                if (type.equals("java.lang.Double")) {
                    exp = exp + ".doubleValue()";
                }
                if (type.equals("java.lang.Float")) {
                    exp = exp + ".floatValue()";
                }
                if (type.equals("java.lang.Integer")) {
                    exp = exp + ".intValue()";
                }
                if (type.equals("java.lang.Long")) {
                    exp = exp + ".longValue()";
                }
                if (type.equals("java.lang.Short")) {
                    exp = exp + ".shortValue()";
                }
            } else if (this.jComboBoxType1.getSelectedIndex() == 1) {
                exp = exp + ".intValue()";
            } else if (this.jComboBoxType1.getSelectedIndex() == 2) {
                exp = exp + ".doubleValue()";
            }
            exp = " (" + exp + ") " + this.jComboBoxOperation.getSelectedItem();
            exp = exp + "(" + expObj2.getExpression();
            if (this.jComboBoxType2.getSelectedIndex() == 0) {
                type = expObj2.getClassType();
                if (type.equals("java.lang.Number")) {
                    exp = exp + ".doubleValue()";
                }
                if (type.equals("java.lang.BigDecimal")) {
                    exp = exp + ".doubleValue()";
                }
                if (type.equals("java.lang.BigInteger")) {
                    exp = exp + ".longValue()";
                }
                if (type.equals("java.lang.Byte")) {
                    exp = exp + ".byteValue()";
                }
                if (type.equals("java.lang.Double")) {
                    exp = exp + ".doubleValue()";
                }
                if (type.equals("java.lang.Float")) {
                    exp = exp + ".floatValue()";
                }
                if (type.equals("java.lang.Integer")) {
                    exp = exp + ".intValue()";
                }
                if (type.equals("java.lang.Long")) {
                    exp = exp + ".longValue()";
                }
                if (type.equals("java.lang.Short")) {
                    exp = exp + ".shortValue()";
                }
            } else if (this.jComboBoxType2.getSelectedIndex() == 1) {
                exp = exp + ".intValue()";
            } else if (this.jComboBoxType2.getSelectedIndex() == 2) {
                exp = exp + ".doubleValue()";
            }
            exp = exp + ")";
            exp = this.jComboBoxReturnType.getSelectedIndex() != 0 ? "new " + this.jComboBoxReturnType.getSelectedItem() + "( " + exp + " )" : (expObj2.getClassType().equals(expObj1.getClassType()) && !expObj2.getClassType().equals("java.lang.Number") ? "new " + expObj2.getClassType() + "( " + exp + " )" : (this.isInteger(expObj2.getClassType()) && this.isInteger(expObj1.getClassType()) ? "new Integer( " + exp + " )" : "new Double( " + exp + " )"));
            this.setExpression(exp);
        }
        this.setDialogResult(0);
        this.dialog.setVisible(false);
        this.dialog.dispose();
    }

    private boolean isInteger(String type) {
        if (type.equals("java.lang.Number")) {
            return true;
        }
        if (type.equals("java.lang.BigInteger")) {
            return true;
        }
        if (type.equals("java.lang.Byte")) {
            return true;
        }
        if (type.equals("java.lang.Integer")) {
            return true;
        }
        if (type.equals("java.lang.Long")) {
            return true;
        }
        return type.equals("java.lang.Short");
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        if (this.dialog != null) {
            this.dialog.setVisible(false);
            this.dialog.dispose();
        }
    }

    private void jList1ValueChanged(ListSelectionEvent evt) {
    }

    private void jToggleButton1ActionPerformed(ActionEvent evt) {
        this.updateAdvancedOptionsStatus(this.jToggleButton1.isSelected());
    }

    public void updateAdvancedOptionsStatus(boolean b) {
        this.jPanelReturnType.setVisible(b);
        this.jLabelAdv1.setVisible(b);
        this.jLabelAdv2.setVisible(b);
        this.jComboBoxType1.setVisible(b);
        this.jComboBoxType2.setVisible(b);
        if (b) {
            this.jToggleButton1.setText(I18n.getString("FewerOptions", "Fewer options"));
        } else {
            this.jToggleButton1.setText(I18n.getString("MoreOptions", "More options"));
        }
    }

    public int getDialogResult() {
        return this.dialogResult;
    }

    public void setDialogResult(int dialogResult) {
        this.dialogResult = dialogResult;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public JDialog getDialog() {
        return this.dialog;
    }

    public void setDialog(JDialog dialog) {
        this.dialog = dialog;
        if (dialog != null) {
            dialog.setTitle(I18n.getString("arithmeticOperationHelper.title", "Arithmetic operation"));
        }
    }

    public void applyI18n() {
        this.jButtonCancel.setText(I18n.getString("arithmeticOperationHelper.buttonCancel", "Cancel"));
        this.jButtonOk.setText(I18n.getString("arithmeticOperationHelper.buttonOk", "Ok"));
        this.jLabel1.setText(I18n.getString("arithmeticOperationHelper.label1", "Value 1"));
        this.jLabel2.setText(I18n.getString("arithmeticOperationHelper.label2", "Value 2"));
        this.jLabelAdv1.setText(I18n.getString("arithmeticOperationHelper.labelAdv1", "Consider this number as:"));
        this.jLabelAdv2.setText(I18n.getString("arithmeticOperationHelper.labelAdv2", "Consider this number as:"));
        this.jLabelReturnType.setText(I18n.getString("arithmeticOperationHelper.labelReturnType", "Return type:"));
        if (this.dialog != null) {
            this.dialog.setTitle(I18n.getString("arithmeticOperationHelper.title", "Arithmetic operation"));
        }
        this.jButtonCancel.setMnemonic(I18n.getString("arithmeticOperationHelper.buttonCancelMnemonic", "c").charAt(0));
        this.jButtonOk.setMnemonic(I18n.getString("arithmeticOperationHelper.buttonOkMnemonic", "o").charAt(0));
    }
}

