/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.graphics;

import java.awt.Color;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.functions.Function;
import org.icepdf.core.pobjects.graphics.PColorSpace;
import org.icepdf.core.util.ColorUtil;
import org.icepdf.core.util.Library;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Separation
extends PColorSpace {
    public static final Name SEPARATION_KEY = new Name("Separation");
    protected Color namedColor;
    protected PColorSpace alternate;
    protected Function tintTransform;
    private boolean isAll;
    public static final String COLORANT_ALL = "all";
    private boolean isNone;
    public static final String COLORANT_NONE = "none";
    private float tint = 1.0f;
    private ConcurrentHashMap<Integer, Color> colorTable1B;
    private ConcurrentHashMap<Integer, Color> colorTable3B;
    private ConcurrentHashMap<Integer, Color> colorTable4B;

    protected Separation(Library l, HashMap h, Object name, Object alternateSpace, Object tintTransform) {
        super(l, h);
        this.alternate = Separation.getColorSpace(l, alternateSpace);
        this.colorTable1B = new ConcurrentHashMap(256);
        this.colorTable3B = new ConcurrentHashMap(256);
        this.colorTable4B = new ConcurrentHashMap(256);
        this.tintTransform = Function.getFunction(l, l.getObject(tintTransform));
        if (name instanceof Name) {
            String colorName = ((Name)name).getName().toLowerCase();
            if (!(colorName.equals("red") || colorName.equals("blue") || colorName.equals("blue") || colorName.equals("black") || colorName.equals("cyan") || colorName.equals("brown") || colorName.equals("auto"))) {
                if (colorName.equals(COLORANT_ALL)) {
                    this.isAll = true;
                } else if (colorName.equals(COLORANT_NONE)) {
                    this.isNone = true;
                }
                return;
            }
            int colorVaue = ColorUtil.convertNamedColor(colorName.toLowerCase());
            if (colorVaue != -1) {
                this.namedColor = new Color(colorVaue);
            }
            if (colorName.equalsIgnoreCase("auto")) {
                this.namedColor = Color.BLACK;
            }
        }
    }

    @Override
    public int getNumComponents() {
        return 1;
    }

    public boolean isNamedColor() {
        return this.namedColor != null;
    }

    @Override
    public Color getColor(float[] components, boolean fillAndStroke) {
        if (this.namedColor != null) {
            this.tint = components[0];
            float[] colour = this.namedColor.getComponents(null);
            Color namedColor = new Color(colour[0], colour[1], colour[2], this.tint);
            if (this.tint < 0.1f && colour[0] == 0.0f && colour[1] == 0.0f && colour[2] == 0.0f) {
                return Color.WHITE;
            }
            return namedColor;
        }
        if (this.tintTransform == null) {
            float colour = components[0];
            float[] alternateColour = new float[this.alternate.getNumComponents()];
            int max = this.alternate.getNumComponents();
            for (int i = 0; i < max; ++i) {
                alternateColour[i] = colour;
            }
            return this.alternate.getColor(alternateColour);
        }
        if (this.alternate != null && !this.isNone) {
            int key = 0;
            int bands = components.length;
            int i = 0;
            int bit = 0;
            while (i < bands) {
                key |= ((int)(components[i] * 255.0f) & 0xFF) << bit;
                ++i;
                bit += 8;
            }
            if (bands == 1) {
                return Separation.addColorToCache(this.colorTable1B, key, this.alternate, this.tintTransform, components);
            }
            if (bands == 3) {
                return Separation.addColorToCache(this.colorTable3B, key, this.alternate, this.tintTransform, components);
            }
            if (bands == 4) {
                return Separation.addColorToCache(this.colorTable4B, key, this.alternate, this.tintTransform, components);
            }
        }
        if (this.isNone) {
            return new Color(0, 0, 0, 0);
        }
        return this.namedColor;
    }

    private static Color addColorToCache(ConcurrentHashMap<Integer, Color> colorCache, int key, PColorSpace alternate, Function tintTransform, float[] f) {
        Color color = colorCache.get(key);
        if (color == null) {
            float[] y = tintTransform.calculate(Separation.reverse(f));
            color = alternate.getColor(Separation.reverse(y));
            colorCache.put(key, color);
            return color;
        }
        return color;
    }

    public float getTint() {
        return this.tint;
    }
}

