/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.exception.JDBCExceptionHelper;
import org.hibernate.id.Configurable;
import org.hibernate.id.IdentifierGeneratorFactory;
import org.hibernate.id.PersistentIdentifierGenerator;
import org.hibernate.mapping.Table;
import org.hibernate.type.Type;
import org.hibernate.util.PropertiesHelper;

public class SequenceGenerator
implements PersistentIdentifierGenerator,
Configurable {
    public static final String SEQUENCE = "sequence";
    public static final String PARAMETERS = "parameters";
    private String sequenceName;
    private String parameters;
    private Type identifierType;
    private String sql;
    private static final Log log = LogFactory.getLog((Class)(class$org$hibernate$id$SequenceGenerator == null ? (class$org$hibernate$id$SequenceGenerator = SequenceGenerator.class$("org.hibernate.id.SequenceGenerator")) : class$org$hibernate$id$SequenceGenerator));
    static /* synthetic */ Class class$org$hibernate$id$SequenceGenerator;

    public void configure(Type type, Properties params, Dialect dialect) throws MappingException {
        this.sequenceName = PropertiesHelper.getString(SEQUENCE, params, "hibernate_sequence");
        this.parameters = params.getProperty(PARAMETERS);
        String schemaName = params.getProperty("schema");
        String catalogName = params.getProperty("catalog");
        if (this.sequenceName.indexOf(dialect.getSchemaSeparator()) < 0) {
            this.sequenceName = Table.qualify(catalogName, schemaName, this.sequenceName, dialect.getSchemaSeparator());
        }
        this.identifierType = type;
        this.sql = dialect.getSequenceNextValString(this.sequenceName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Serializable generate(SessionImplementor session, Object obj) throws HibernateException {
        Serializable serializable;
        PreparedStatement st = session.getBatcher().prepareSelectStatement(this.sql);
        try {
            Serializable result;
            ResultSet rs = st.executeQuery();
            try {
                rs.next();
                result = IdentifierGeneratorFactory.get(rs, this.identifierType);
            }
            finally {
                rs.close();
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Sequence identifier generated: " + result));
            }
            serializable = result;
        }
        catch (Throwable throwable) {
            try {
                session.getBatcher().closeStatement(st);
                throw throwable;
            }
            catch (SQLException sqle) {
                throw JDBCExceptionHelper.convert(session.getFactory().getSQLExceptionConverter(), sqle, "could not get next sequence value", this.sql);
            }
        }
        session.getBatcher().closeStatement(st);
        return serializable;
    }

    public String[] sqlCreateStrings(Dialect dialect) throws HibernateException {
        String[] ddl = dialect.getCreateSequenceStrings(this.sequenceName);
        if (this.parameters != null) {
            int n = ddl.length - 1;
            ddl[n] = ddl[n] + ' ' + this.parameters;
        }
        return ddl;
    }

    public String[] sqlDropStrings(Dialect dialect) throws HibernateException {
        return dialect.getDropSequenceStrings(this.sequenceName);
    }

    public Object generatorKey() {
        return this.sequenceName;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

