/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui.style;

import it.businesslogic.ireport.JasperTemplate;
import it.businesslogic.ireport.Style;
import it.businesslogic.ireport.Template;
import it.businesslogic.ireport.UndefinedStyle;
import java.awt.Color;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;

public class StyleCellRenderer
extends DefaultTreeCellRenderer {
    static ImageIcon styleIcon;
    static ImageIcon undefinedStyleIcon;
    static ImageIcon templateIcon;
    static ImageIcon linkTemplateIcon;

    public StyleCellRenderer() {
        if (styleIcon == null) {
            styleIcon = new ImageIcon(this.getClass().getResource("/it/businesslogic/ireport/icons/styles/style.png"));
        }
        if (undefinedStyleIcon == null) {
            undefinedStyleIcon = new ImageIcon(this.getClass().getResource("/it/businesslogic/ireport/icons/styles/undefinedStyle.png"));
        }
        if (templateIcon == null) {
            templateIcon = new ImageIcon(this.getClass().getResource("/it/businesslogic/ireport/icons/styles/template.png"));
        }
        if (linkTemplateIcon == null) {
            linkTemplateIcon = new ImageIcon(this.getClass().getResource("/it/businesslogic/ireport/icons/styles/linktemplate.png"));
        }
    }

    public Component getTreeCellRendererComponent(JTree tree, Object node, boolean isSelected, boolean isExpanded, boolean isLeaf, int row, boolean cellHasFocus) {
        JLabel c = (JLabel)super.getTreeCellRendererComponent(tree, node, isSelected, isExpanded, isLeaf, row, cellHasFocus);
        ImageIcon icon = this.getElementIcon(node);
        if (icon != null) {
            c.setIcon(icon);
        }
        return c;
    }

    protected ImageIcon getElementIcon(Object value) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
        this.setForeground(Color.BLACK);
        if (node.getUserObject() instanceof UndefinedStyle) {
            this.setForeground(Color.GRAY);
        }
        if (node.getUserObject() instanceof UndefinedStyle) {
            return undefinedStyleIcon;
        }
        if (node.getUserObject() instanceof Style) {
            return styleIcon;
        }
        if (node.getUserObject() instanceof JasperTemplate) {
            if (((JasperTemplate)node.getUserObject()).getParent() == null) {
                return templateIcon;
            }
            return linkTemplateIcon;
        }
        if (node.getUserObject() instanceof Template) {
            return linkTemplateIcon;
        }
        return undefinedStyleIcon;
    }

    public Color getBackgroundNonSelectionColor() {
        return null;
    }

    public Color getBackground() {
        return null;
    }
}

