/*
 * Decompiled with CFR 0.152.
 */
package com.github.sarxos.webcam.ds.cgt;

import com.github.sarxos.webcam.WebcamDevice;
import com.github.sarxos.webcam.WebcamDriver;
import com.github.sarxos.webcam.WebcamTask;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebcamReadBufferTask
extends WebcamTask {
    private static final Logger LOG = LoggerFactory.getLogger(WebcamReadBufferTask.class);
    private volatile ByteBuffer buffer = null;

    public WebcamReadBufferTask(WebcamDriver driver, WebcamDevice device) {
        super(driver, device);
    }

    public ByteBuffer getBuffer() {
        try {
            this.process();
        }
        catch (InterruptedException e) {
            LOG.debug("Image buffer request interrupted", (Throwable)e);
            return null;
        }
        return this.buffer;
    }

    protected void handle() {
        WebcamDevice device = this.getDevice();
        if (!device.isOpen()) {
            return;
        }
        if (!(device instanceof WebcamDevice.BufferAccess)) {
            return;
        }
        this.buffer = ((WebcamDevice.BufferAccess)((Object)device)).getImageBytes();
    }
}

