/*
 * Decompiled with CFR 0.152.
 */
package com.topaz.sigplus.util;

import com.topaz.sigplus.util.SigDataPoint;
import java.util.Vector;

public class SigInfo {
    Vector pointData;
    Vector strokeData;
    int numPoints;
    int numStrokes;

    public int getNumPoints() {
        return this.numPoints;
    }

    public int getNumPointsInStroke(int stroke) {
        if (stroke >= this.numStrokes) {
            return 0;
        }
        if (stroke == this.numStrokes - 1) {
            return this.pointData.size() - (Integer)this.strokeData.elementAt(stroke);
        }
        return (Integer)this.strokeData.elementAt(stroke + 1) - (Integer)this.strokeData.elementAt(stroke);
    }

    public int getNumStrokes() {
        return this.numStrokes;
    }

    public Vector getPointData() {
        return this.pointData;
    }

    public Vector getStrokeData() {
        return this.strokeData;
    }

    public int getXExtent() {
        int maxX = 0;
        int minX = 65536;
        if (this.numPoints == 0) {
            return 0;
        }
        int i = 0;
        while (i < this.numPoints) {
            SigDataPoint pnt = (SigDataPoint)this.pointData.elementAt(i);
            if (pnt.x > maxX) {
                maxX = pnt.x;
            }
            if (pnt.x < minX) {
                minX = pnt.x;
            }
            ++i;
        }
        return maxX - minX;
    }

    public int getYExtent() {
        int maxY = 0;
        int minY = 65536;
        if (this.numPoints == 0) {
            return 0;
        }
        int i = 0;
        while (i < this.numPoints) {
            SigDataPoint pnt = (SigDataPoint)this.pointData.elementAt(i);
            if (pnt.y > maxY) {
                maxY = pnt.y;
            }
            if (pnt.y < minY) {
                minY = pnt.y;
            }
            ++i;
        }
        return maxY - minY;
    }

    public SigDataPoint getPointInStroke(int strokeNumber, int pointNumber) {
        if (strokeNumber < 0 || strokeNumber >= this.numStrokes) {
            return null;
        }
        int idx = (Integer)this.strokeData.elementAt(strokeNumber);
        return (SigDataPoint)this.pointData.elementAt(idx += pointNumber);
    }
}

