/*
 * Decompiled with CFR 0.152.
 */
package com.topaz.sigplus.util;

import com.topaz.sigplus.util.BitmapCharacter;
import com.topaz.sigplus.util.SigInputStream;
import java.io.FileInputStream;
import java.io.IOException;

public class CharacterMap {
    int numCharacters;
    BitmapCharacter[] characters;

    public boolean loadCharacterMap(String fontFileName) {
        byte[] buffer;
        try {
            FileInputStream file = new FileInputStream(fontFileName);
            buffer = new byte[file.available()];
            file.read(buffer);
            file.close();
        }
        catch (IOException e) {
            return false;
        }
        SigInputStream fontStream = new SigInputStream(buffer);
        this.numCharacters = fontStream.readBinaryShort();
        this.characters = new BitmapCharacter[this.numCharacters];
        int i = 0;
        while (i < this.numCharacters) {
            this.characters[i] = new BitmapCharacter();
            this.characters[i].charCode = (short)fontStream.readBinaryByte();
            this.characters[i].xSize = (short)fontStream.readBinaryShort();
            this.characters[i].ySize = (short)fontStream.readBinaryShort();
            this.characters[i].lineSize = (short)((this.characters[i].xSize - 1) / 8 + 1);
            int dataSize = this.characters[i].lineSize * this.characters[i].ySize;
            this.characters[i].data = new byte[dataSize];
            int j = 0;
            while (j < dataSize) {
                this.characters[i].data[j] = (byte)fontStream.readBinaryByte();
                ++j;
            }
            ++i;
        }
        return true;
    }

    public BitmapCharacter lookupCharacter(short charCode) {
        int i = 0;
        while (i < this.numCharacters) {
            if (this.characters[i].charCode == charCode) {
                return this.characters[i];
            }
            ++i;
        }
        return null;
    }
}

