/*
 * Decompiled with CFR 0.152.
 */
package com.topaz.sigplus.microutil;

import com.topaz.sigplus.microutil.MicroSigDataType;
import com.topaz.sigplus.microutil.SigDataPoint;
import com.topaz.sigplus.microutil.SigOutputStream;

public class MicroSigWriter {
    static final int CR = 13;
    static final int LF = 10;
    static final int SP = 32;
    int compMode;

    public MicroSigWriter(int compressionMode) {
        this.compMode = compressionMode < 1 ? 1 : compressionMode;
    }

    public byte[] writeSigCompressed(MicroSigDataType sig) {
        SigOutputStream sigStream = new SigOutputStream();
        int firstPointInStroke = 0;
        int deltaSamps = this.compMode;
        int numStrokes = sig.strokes.size();
        sigStream.writeBinaryShort(numStrokes);
        int i = 0;
        while (i < numStrokes) {
            int dy;
            int dx;
            SigDataPoint pnt;
            int v = sig.getNumberOfPointsInStroke(i);
            int nPoints = (v - 2) / deltaSamps + 2;
            sigStream.writeBinaryShort(nPoints);
            SigDataPoint prevPnt = (SigDataPoint)sig.points.elementAt(firstPointInStroke);
            sigStream.writeBinaryShort(prevPnt.x);
            sigStream.writeBinaryShort(prevPnt.y);
            int j = firstPointInStroke + 1;
            while (j < firstPointInStroke + v - 1) {
                if ((j - firstPointInStroke) % deltaSamps == 0) {
                    pnt = (SigDataPoint)sig.points.elementAt(j);
                    dx = pnt.x - prevPnt.x;
                    dy = pnt.y - prevPnt.y;
                    sigStream.writeBinaryByte(dx);
                    sigStream.writeBinaryByte(dy);
                    prevPnt = pnt;
                }
                ++j;
            }
            pnt = (SigDataPoint)sig.points.elementAt(j);
            dx = pnt.x - prevPnt.x;
            dy = pnt.y - prevPnt.y;
            sigStream.writeBinaryByte(dx);
            sigStream.writeBinaryByte(dy);
            firstPointInStroke += v;
            ++i;
        }
        return sigStream.toByteArray();
    }

    public byte[] writeSigToByteArray(MicroSigDataType sig) {
        byte[] sigArray = this.writeSigCompressed(sig);
        return sigArray;
    }
}

