/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.osiris3.platform;

import com.rameses.osiris3.platform.OSManager;
import com.rameses.osiris3.platform.OSPlatform;
import com.rameses.osiris3.platform.OSView;
import com.rameses.osiris3.platform.WindowContainer;
import com.rameses.platform.interfaces.SubWindow;
import com.rameses.platform.interfaces.SubWindowListener;
import com.rameses.platform.interfaces.ViewContext;
import java.awt.Container;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;

public class OSPopupDialog
extends JDialog
implements SubWindow,
WindowListener {
    private ViewContext viewContext;
    private OSPlatform platformImpl;
    private OSView osview;
    private boolean canClose = true;
    private String id;
    private JComponent source;

    public OSPopupDialog() {
        this.init();
    }

    public OSPopupDialog(JFrame parent) {
        super(parent);
        this.init();
    }

    public OSPopupDialog(JDialog parent) {
        super(parent);
        this.init();
    }

    private void init() {
        this.setDefaultCloseOperation(0);
        this.addWindowListener(this);
    }

    public JComponent getSource() {
        return this.source;
    }

    public void setSource(JComponent source) {
        this.source = source;
    }

    @Override
    public void setContentPane(Container contentPane) {
        super.setContentPane(contentPane);
        if (contentPane instanceof ViewContext) {
            this.viewContext = (ViewContext)((Object)contentPane);
        }
    }

    public boolean isCanClose() {
        return this.canClose;
    }

    public void setCanClose(boolean canClose) {
        this.canClose = canClose;
    }

    OSPlatform getPlatformImpl() {
        return this.platformImpl;
    }

    void setPlatformImpl(OSPlatform platformImpl) {
        this.platformImpl = platformImpl;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
    }

    @Override
    public void setListener(SubWindowListener listener) {
    }

    @Override
    public String getName() {
        return this.getId();
    }

    @Override
    public void closeWindow() {
        if (!this.canClose) {
            return;
        }
        if (this.viewContext != null && !this.viewContext.close()) {
            return;
        }
        super.dispose();
        OSManager.getInstance().unregisterView(this.getId());
        this.getContentPane().firePropertyChange("Window.close", 0L, 1L);
        JComponent source = this.getSource();
        if (source != null) {
            source.firePropertyChange("Window.close", false, true);
        }
    }

    @Override
    public void update(Map windowAttributes) {
        Object oid;
        if (windowAttributes == null || windowAttributes.isEmpty()) {
            return;
        }
        Object otitle = windowAttributes.remove("title");
        if (otitle != null) {
            this.setTitle(otitle.toString());
        }
        if ((oid = windowAttributes.remove("id")) != null) {
            String newId = oid.toString();
            String oldId = this.getName();
            if (newId != null && oldId != null && !newId.equals(oldId)) {
                OSManager osm = OSManager.getInstance();
                OSView view = osm.unregisterView(oldId);
                this.setId(newId);
                osm.registerView(newId, view);
            }
        }
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.closeWindow();
    }

    @Override
    public void windowOpened(WindowEvent e) {
        if (this.viewContext != null) {
            this.viewContext.display();
            this.viewContext.setSubWindow(this);
        }
        if (this.osview == null) {
            this.osview = new OSViewImpl();
            OSManager.getInstance().registerView(this.getId(), this.osview);
        }
    }

    private class OSViewImpl
    implements OSView {
        OSPopupDialog root;

        private OSViewImpl() {
            this.root = OSPopupDialog.this;
        }

        @Override
        public String getId() {
            return this.root.getId();
        }

        @Override
        public String getType() {
            return "popup";
        }

        @Override
        public void requestFocus() {
            this.root.requestFocus();
        }

        @Override
        public void closeView() {
            this.root.closeWindow();
        }

        @Override
        public WindowContainer getWindowContainer() {
            return null;
        }
    }
}

