/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.osiris3.platform;

import com.rameses.osiris3.platform.OSManager;
import com.rameses.osiris3.platform.OSView;
import com.rameses.osiris3.platform.SubWindowImpl;
import com.rameses.osiris3.platform.WindowContainer;
import com.rameses.osiris3.platform.WindowTabbedPane;
import com.rameses.platform.interfaces.ContentPane;
import com.rameses.platform.interfaces.SubWindow;
import com.rameses.platform.interfaces.SubWindowContainer;
import com.rameses.platform.interfaces.SubWindowListener;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Rectangle;
import java.rmi.server.UID;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class OSMainTabbedPane
extends WindowTabbedPane
implements WindowContainer,
SubWindowContainer {
    private Map<String, Component> tabIndex = new Hashtable<String, Component>();
    private Rectangle closeIconBounds = new Rectangle(0, 0, 10, 10);
    private boolean closeIconHover;

    public OSMainTabbedPane() {
        this.setFocusable(false);
        this.addChangeListener(new ItemSelector());
    }

    public boolean containsView(String id) {
        return this.tabIndex.get(id) != null;
    }

    public Component findWindow(String id) {
        return this.tabIndex.get(id);
    }

    @Override
    public void insertTab(String title, Icon icon, Component component, String tip, int index) {
        final String _title = title;
        final Icon _icon = icon;
        final Component _component = component;
        final String _tip = tip;
        final int _index = index;
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                OSMainTabbedPane.this.insertTabImpl(_title, _icon, _component, _tip, _index);
            }
        });
    }

    private void insertTabImpl(String title, Icon icon, Component component, String tip, int index) {
        Component old;
        String tabid;
        SubWindowImpl subWindow = null;
        if (component instanceof SubWindowImpl) {
            subWindow = (SubWindowImpl)component;
            subWindow.setListener(new SubWindowHandler());
            String str = subWindow.getTitle();
            if (str != null && str.trim().length() > 0) {
                title = str;
            }
        }
        String string = tabid = subWindow == null ? component.getName() : subWindow.getId();
        if (tabid == null) {
            tabid = "WIN" + new UID();
            if (subWindow == null) {
                component.setName(tabid);
            } else {
                subWindow.setId(tabid);
            }
        }
        if ((old = this.tabIndex.get(tabid)) != null && this.indexOfComponent(old) >= 0) {
            this.setSelectedComponent(old);
            return;
        }
        super.insertTab(title, icon, component, tip, index);
        this.setSelectedIndex(index);
        this.tabIndex.put(tabid, component);
        OSViewImpl osv = new OSViewImpl(component);
        OSManager.getInstance().registerView(tabid, osv);
    }

    @Override
    protected boolean beforeClose(Component component) {
        int idx = this.indexOfComponent(component);
        if (idx >= 0) {
            String title = this.getTitleAt(idx);
            this.tabIndex.remove(title);
            String cname = component.getName();
            if (cname != null) {
                this.tabIndex.remove(cname);
                OSManager.getInstance().unregisterView(cname);
            }
        }
        return true;
    }

    @Override
    public void removeAll() {
        super.removeAll();
        this.tabIndex.clear();
    }

    @Override
    protected boolean isCloseable(int index) {
        Component comp = null;
        try {
            comp = this.getComponentAt(index);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (comp instanceof ContentPane) {
            ContentPane cp = (ContentPane)((Object)comp);
            return cp.isCanClose();
        }
        return false;
    }

    protected void afterClose(Component component) {
    }

    public void showInfo() {
        Component comp = this.getSelectedComponent();
        if (!(comp instanceof ContentPane)) {
            return;
        }
        ContentPane cp = (ContentPane)((Object)comp);
        ContentPane.View vw = cp.getView();
        if (vw != null) {
            vw.showInfo();
        }
    }

    @Override
    public void add(SubWindow window) {
        if (!(window instanceof JComponent)) {
            throw new IllegalStateException("window parameter must be an instance of SubWindow and JComponent");
        }
        JComponent jc = (JComponent)((Object)window);
        jc.putClientProperty("SubWindow.id", window.getName());
        window.setListener(new SubWindowHandler());
        this.addTab(window.getTitle(), jc);
    }

    private class OSViewImpl
    implements OSView {
        OSMainTabbedPane root;
        Component view;
        SubWindowImpl subWindow;

        OSViewImpl(Component view) {
            this.root = OSMainTabbedPane.this;
            this.view = view;
            if (view instanceof SubWindowImpl) {
                this.subWindow = (SubWindowImpl)view;
                this.subWindow.setView(this);
            }
        }

        @Override
        public WindowContainer getWindowContainer() {
            return this.root;
        }

        @Override
        public String getId() {
            return this.view.getName();
        }

        @Override
        public String getType() {
            return "tab";
        }

        @Override
        public void requestFocus() {
            if (OSMainTabbedPane.this.indexOfComponent(this.view) >= 0) {
                this.root.setSelectedComponent(this.view);
            }
            if (this.subWindow != null) {
                this.subWindow.activate();
            }
        }

        @Override
        public void closeView() {
            if (this.subWindow == null) {
                this.root.remove(this.view);
            } else {
                this.subWindow.close();
            }
        }
    }

    private class ItemSelector
    implements ChangeListener {
        private ItemSelector() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            Component comp = OSMainTabbedPane.this.getSelectedComponent();
            if (comp instanceof ContentPane) {
                ((ContentPane)((Object)comp)).activate();
            }
        }
    }

    private class SubWindowHandler
    implements SubWindowListener {
        private SubWindowHandler() {
        }

        @Override
        public void fireUpdate(SubWindow window) {
            if (window == null) {
                return;
            }
            if (!(window instanceof Component)) {
                throw new IllegalStateException("window parameter must be an instance of SubWindow and Component");
            }
            JComponent jc = (JComponent)((Object)window);
            int index = OSMainTabbedPane.this.indexOfComponent(jc);
            if (index < 0) {
                return;
            }
            OSMainTabbedPane.this.setTitleAt(index, window.getTitle() + "          ");
            String newId = window.getName();
            String oldId = jc.getClientProperty("SubWindow.id") + "";
            if (oldId != null && newId != null && !oldId.equals(newId)) {
                OSMainTabbedPane.this.tabIndex.remove(oldId);
                OSMainTabbedPane.this.tabIndex.put(newId, jc);
            }
            jc.putClientProperty("SubWindow.id", newId);
        }
    }
}

