/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.perspective.persist.xml;

import org.flexdock.docking.Dockable;
import org.flexdock.docking.state.DockingState;
import org.flexdock.docking.state.FloatingGroup;
import org.flexdock.docking.state.LayoutNode;
import org.flexdock.perspective.Layout;
import org.flexdock.perspective.persist.xml.ISerializer;
import org.flexdock.perspective.persist.xml.SerializerRegistry;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LayoutSerializer
implements ISerializer {
    public Element serialize(Document document, Object object) {
        Layout layout = (Layout)object;
        Element layoutElement = document.createElement("Layout");
        Dockable[] dockables = layout.getDockables();
        ISerializer dockingStateSerializer = SerializerRegistry.getSerializer(DockingState.class);
        for (int i = 0; i < dockables.length; ++i) {
            Dockable dockable = dockables[i];
            DockingState dockingState = layout.getDockingState(dockable);
            Element dockingStateElement = dockingStateSerializer.serialize(document, dockingState);
            layoutElement.appendChild(dockingStateElement);
        }
        ISerializer floatingGroupSerializer = SerializerRegistry.getSerializer(FloatingGroup.class);
        String[] floatingGroupIds = layout.getFloatingGroupIds();
        for (int i = 0; i < floatingGroupIds.length; ++i) {
            String floatingGroupId = floatingGroupIds[i];
            FloatingGroup floatingGroup = layout.getGroup(floatingGroupId);
            Element floatingGroupElement = floatingGroupSerializer.serialize(document, floatingGroup);
            layoutElement.appendChild(floatingGroupElement);
        }
        LayoutNode layoutNode = layout.getRestorationLayout();
        if (layoutNode != null) {
            ISerializer layoutNodeSerializer = SerializerRegistry.getSerializer(LayoutNode.class);
            Element layoutNodeElement = layoutNodeSerializer.serialize(document, layoutNode);
            layoutElement.appendChild(layoutNodeElement);
        }
        return layoutElement;
    }

    public Object deserialize(Element element) {
        Layout layout = new Layout();
        ISerializer dockingStateSerializer = SerializerRegistry.getSerializer(DockingState.class);
        NodeList dockingStateNodeList = element.getElementsByTagName("DockingState");
        for (int i = 0; i < dockingStateNodeList.getLength(); ++i) {
            Node node = dockingStateNodeList.item(i);
            if (!(node instanceof Element)) continue;
            Element dockingStateElement = (Element)node;
            DockingState dockingState = (DockingState)dockingStateSerializer.deserialize(dockingStateElement);
            String dockableId = dockingState.getDockableId();
            layout.setDockingState(dockableId, dockingState);
        }
        ISerializer floatingGroupsSerializer = SerializerRegistry.getSerializer(FloatingGroup.class);
        NodeList floatingGroupsNodeList = element.getElementsByTagName("FloatingGroup");
        for (int i = 0; i < floatingGroupsNodeList.getLength(); ++i) {
            Node floatingGroupNode = floatingGroupsNodeList.item(i);
            if (!(floatingGroupNode instanceof Element)) continue;
            Element floatingGroupElement = (Element)floatingGroupNode;
            FloatingGroup floatingGroup = (FloatingGroup)floatingGroupsSerializer.deserialize(floatingGroupElement);
            layout.addFloatingGroup(floatingGroup);
        }
        ISerializer layoutNodeSerializer = SerializerRegistry.getSerializer(LayoutNode.class);
        NodeList dockingPortNodeList = element.getElementsByTagName("DockingPortNode");
        if (dockingPortNodeList.getLength() > 0 && dockingPortNodeList.item(0) instanceof Element) {
            Element layoutNodeElement = (Element)dockingPortNodeList.item(0);
            LayoutNode restorationLayout = (LayoutNode)layoutNodeSerializer.deserialize(layoutNodeElement);
            layout.setRestorationLayout(restorationLayout);
        }
        return layout;
    }
}

